<%
'Create the query based on user input
If Request("SearchString") <> "" Then
  Query = "@contents " & Request("SearchString") & " and "
End If
If Request("Limit") = "Days" Then
  Query = Query & " @write > " & "-" & Request("Days") & "d"
Else
  Query = Query & " @write > " & "-" & Request("Hours") & "h"
End If
Set objQuery = Server.CreateObject("ixsso.Query")
objQuery.Query = Query
objQuery.MaxRecords = 5
objQuery.SortBy = "filename[d]"
objQuery.Columns = "vpath,path,filename,size,write, characterization"
If Request("Scope") <> "" Then
  Set objUtil = Server.CreateObject("ixsso.util")
  objUtil.AddScopeToQuery objQuery, Request("Scope"), "shallow"
End If
Set objRS = objQuery.CreateRecordset("nonsequential")
If objRS.EOF Then
  Response.Write("No records found!")
  Response.End
End If
%>

<html><head><title>Search Results</title></head>
<body>
<h1>Search Results</h1>
<table border="0" width="100%">
<% do while not objRS.EOF %>
 <tr>
  <td width="20%" align="right"><b>Virtual Path:</b></td>
  <td width="80%"><%= objRS("vPath")%></td>
 </tr>
 <tr>
  <td width="20%" align="right"><b>Physical Path:</b></td>
  <td width="80%"><%= objRS("Path")%></td>
 </tr>
 <tr>
  <td width="20%" align="right"><b>Filename:</b></td>
  <td width="80%"><%= objRS("Filename")%></td>
 </tr>
 <tr>
  <td width="20%" align="right"><b>Size:</b></td>
  <td width="80%"><%= objRS("Size")%></td>
 </tr>
 <tr>
  <td width="20%" align="right"><b>Last Modified:</b></td>
  <td width="80%"><%= objRS("Write")%></td>
 </tr>
 <tr>
  <td width="20%" align="right"><b>Exceprt:</b></td>
  <td width="80%"><%= objRS("Characterization")%></td>
 </tr>
<% objRS.MoveNext %>
<% Loop %>
</table>
</body>
</html>
